package nemosofts.voxradio.fragment.online;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.OptIn;
import androidx.appcompat.widget.SearchView;
import androidx.core.view.MenuHost;
import androidx.core.view.MenuProvider;
import androidx.fragment.app.Fragment;
import androidx.media3.common.util.UnstableApi;
import androidx.nemosofts.utils.NetworkUtils;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.startapp.sdk.ads.nativead.NativeAdPreferences;
import com.startapp.sdk.ads.nativead.StartAppNativeAd;
import com.startapp.sdk.adsbase.Ad;
import com.startapp.sdk.adsbase.adlisteners.AdEventListener;

import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

import java.util.ArrayList;

import nemosofts.voxradio.R;
import nemosofts.voxradio.activity.PlayerService;
import nemosofts.voxradio.adapter.AdapterRadioList;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.callback.Method;
import nemosofts.voxradio.dialog.DialogUtil;
import nemosofts.voxradio.executor.LoadRadio;
import nemosofts.voxradio.interfaces.RadioListener;
import nemosofts.voxradio.interfaces.RewardAdListener;
import nemosofts.voxradio.item.ItemCat;
import nemosofts.voxradio.item.ItemPodcasts;
import nemosofts.voxradio.item.ItemRadio;
import nemosofts.voxradio.utils.GlobalBus;
import nemosofts.voxradio.utils.helper.DBHelper;
import nemosofts.voxradio.utils.helper.Helper;
import nemosofts.voxradio.utils.helper.SPHelper;
import nemosofts.voxradio.utils.recycler.EndlessRecyclerViewScrollListener;

public class FragmentRecent extends Fragment {

    private static final String TAG = "FragmentRecent";
    private Helper helper;
    private SPHelper spHelper;
    private RecyclerView rv;
    private AdapterRadioList adapter;
    private ArrayList<ItemRadio> arrayList;
    private Boolean isOver = false;
    private Boolean isScroll = false;
    private Boolean isLoading = false;
    private int page = 1;
    private ProgressBar pb;
    private FloatingActionButton fab;
    private String errorMsg;
    private FrameLayout frameLayout;
    private static final String ADDED_FROM = "FragmentRecent";
    private SearchView searchView;
    private String recentSongIDs = "";

    @Override
    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_latest, container, false);

        spHelper = new SPHelper(getActivity());
        helper = new Helper(getActivity(), (position, type) -> playRadio(position));

        arrayList = new ArrayList<>();

        frameLayout = rootView.findViewById(R.id.fl_empty);
        fab = rootView.findViewById(R.id.fab);
        pb = rootView.findViewById(R.id.pb);
        rv = rootView.findViewById(R.id.rv);

        LinearLayoutManager manager = new LinearLayoutManager(getActivity());
        rv.setLayoutManager(manager);
        rv.setItemAnimator(new DefaultItemAnimator());
        rv.setNestedScrollingEnabled(false);
        rv.addOnScrollListener(new EndlessRecyclerViewScrollListener(manager) {
            @Override
            public void onLoadMore(int p, int totalItemsCount) {
                if (getActivity() != null && (Boolean.FALSE.equals(isOver) && (Boolean.FALSE.equals(isLoading)))) {
                    isLoading = true;
                    new Handler(Looper.getMainLooper()).postDelayed(() -> {
                        isScroll = true;
                        getData();
                    }, 0);
                }
            }
        });
        rv.addOnScrollListener(new RecyclerView.OnScrollListener() {
            @Override
            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                int firstVisibleItem = manager.findFirstVisibleItemPosition();
                if (firstVisibleItem > 6) {
                    fab.show();
                } else {
                    fab.hide();
                }
            }
        });

        fab.setOnClickListener(v -> rv.smoothScrollToPosition(0));

        loadRe();

        addMenuProvider();
        return rootView;
    }

    private void loadRe() {
        recentSongIDs = new DBHelper(requireActivity()).getRecentIDs("100");
        if(!recentSongIDs.isEmpty()) {
            getData();
        } else {
            errorMsg = getString(R.string.err_no_data_found);
            setEmpty();
        }
    }

    private void getData() {
        if (!NetworkUtils.isConnected(requireContext())) {
            errorMsg = getString(R.string.err_internet_not_connected);
            setEmpty();
            return;
        }
        LoadRadio loadRadio = new LoadRadio(new RadioListener() {
            @Override
            public void onStart() {
                if (arrayList.isEmpty()) {
                    frameLayout.setVisibility(View.GONE);
                    rv.setVisibility(View.GONE);
                    pb.setVisibility(View.VISIBLE);
                }
            }

            @Override
            public void onEnd(String success, String verifyStatus, String message, ArrayList<ItemRadio> arrayListRadio) {
                if (getActivity() == null) {
                    return;
                }
                if (success.equals("1")) {
                    loadRadioEnd(verifyStatus, message, arrayListRadio);
                } else {
                    errorMsg = getString(R.string.err_server_not_connected);
                    setEmpty();
                }
                isLoading = false;
            }
        }, helper.getAPIRequest(Method.METHOD_RADIO_RECENT, page, recentSongIDs, "",
                "", "", spHelper.getUserId(), "", "", "",
                "", "", "", "", null));
        loadRadio.execute();
    }

    private void loadRadioEnd(String verifyStatus, String message, ArrayList<ItemRadio> arrayListRadio) {
        if (verifyStatus.equals("-1")) {
            DialogUtil.verifyDialog(requireActivity(), getString(R.string.err_unauthorized_access), message, () -> {
            });
            return;
        }

        if (arrayListRadio.isEmpty()) {
            isOver = true;
            errorMsg = getString(R.string.err_no_data_found);
            setEmpty();
        } else {
            if (page == Callback.getRecentLimit()){
                isOver = true;
            } else {
                arrayList.addAll(arrayListRadio);
                if (Boolean.TRUE.equals(isScroll) && Callback.getAddedFrom().equals(ADDED_FROM)) {
                    Callback.getArrayListPlay().clear();
                    Callback.setArrayListPlay(arrayList);
                    try {
                        GlobalBus.getBus().postSticky(new ItemPodcasts("", "", null));
                    } catch (Exception e) {
                        Log.e(TAG, "Error in postSticky", e);
                    }
                }
                page = page + 1;
                setAdapter();
            }
        }
    }

    @SuppressLint("NotifyDataSetChanged")
    public void setAdapter() {
        if(Boolean.FALSE.equals(isScroll)) {
            adapter = new AdapterRadioList(requireContext(), false, arrayList, new AdapterRadioList.RecyclerItemClickListener() {
                @Override
                public void onClick(int position) {
                    helper.showInterAd(position, "");
                }

                @Override
                public void onRewardAds(int position) {
                    if (spHelper.getRewardCredit() != 0){
                        spHelper.useRewardCredit(1);
                        playRadio(position);
                        Toast.makeText(requireActivity(), "Your Total Credit ("+spHelper.getRewardCredit()+")", Toast.LENGTH_SHORT).show();
                    } else {
                        helper.showRewardAds(position, new RewardAdListener() {
                            @Override
                            public void onClick(boolean isLoad, int pos) {
                                if (isLoad){
                                    spHelper.addRewardCredit(Callback.getRewardCredit());
                                    spHelper.useRewardCredit(1);
                                    playRadio(pos);
                                    Toast.makeText(requireActivity(), "Your Total Credit ("+spHelper.getRewardCredit()+")", Toast.LENGTH_SHORT).show();
                                } else {
                                    Toast.makeText(requireActivity(), "Display Failed", Toast.LENGTH_SHORT).show();
                                }
                            }

                            @Override
                            public void onPurchases(int pos) {
                                playRadio(pos);
                            }
                        });
                    }
                }
            });
            rv.setAdapter(adapter);
            rv.scheduleLayoutAnimation();
            setEmpty();
            loadNativeAds();
        } else {
            adapter.notifyDataSetChanged();
        }
    }

    @OptIn(markerClass = UnstableApi.class)
    private void playRadio(int position) {
        Callback.setIsRadio(true);
        if (!Callback.getAddedFrom().equals(ADDED_FROM)) {
            Callback.getArrayListPlay().clear();
            Callback.setArrayListPlay(arrayList);
            Callback.setAddedFrom(ADDED_FROM);
            Callback.setIsNewAdded(true);
        }
        Callback.setPlayPos(position);

        Intent intent = new Intent(getActivity(), PlayerService.class);
        intent.setAction(PlayerService.ACTION_PLAY);
        requireActivity().startService(intent);
    }

    private void loadNativeAds() {
        if (helper.canLoadNativeAds(requireContext(), Callback.PAGE_NATIVE_POST) && arrayList.size() >= 10) {
            switch (Callback.getAdNetwork()) {
                case Callback.AD_TYPE_ADMOB -> {
                    AdLoader.Builder builder = new AdLoader.Builder(requireContext(), Callback.getAdmobNativeAdID());
                    AdLoader adLoader = builder.forNativeAd(
                            nativeAd -> {
                                // A native ad loaded successfully, check if the ad loader has finished loading
                                // and if so, insert the ads into the list.
                                try {
                                    adapter.addAds(nativeAd);
                                } catch (Exception e) {
                                    Log.e(TAG, "Error in loadNativeAds", e);
                                }
                            }).build();

                    // Load the Native Express ad.
                    adLoader.loadAds(new AdRequest.Builder().build(), 5);
                }
                case Callback.AD_TYPE_STARTAPP -> {
                    StartAppNativeAd nativeAd = new StartAppNativeAd(requireContext());
                    nativeAd.loadAd(new NativeAdPreferences()
                            .setAdsNumber(3)
                            .setAutoBitmapDownload(true)
                            .setPrimaryImageSize(2), new AdEventListener() {
                        @Override
                        public void onReceiveAd(@NonNull Ad ad) {
                            if (adapter != null) {
                                adapter.addNativeAds(nativeAd.getNativeAds());
                            }
                        }

                        @Override
                        public void onFailedToReceiveAd(Ad ad) {
                            // this method is empty
                        }
                    });
                }
                case Callback.AD_TYPE_APPLOVIN ->
                        adapter.setNativeAds(true);
                default ->
                        adapter.setNativeAds(false);
            }
        }
    }

    private void setEmpty() {
        if (!arrayList.isEmpty()) {
            rv.setVisibility(View.VISIBLE);
            pb.setVisibility(View.INVISIBLE);
            frameLayout.setVisibility(View.GONE);
        } else {
            pb.setVisibility(View.INVISIBLE);
            rv.setVisibility(View.GONE);
            frameLayout.setVisibility(View.VISIBLE);

            frameLayout.removeAllViews();
            LayoutInflater inflater = (LayoutInflater) requireContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);

            @SuppressLint("InflateParams") View myView = inflater.inflate(R.layout.row_empty, null);

            TextView textView = myView.findViewById(R.id.tv_empty_msg);
            textView.setText(errorMsg);

            myView.findViewById(R.id.ll_empty_try).setOnClickListener(v -> {
                myView.findViewById(R.id.iv_empty).setVisibility(View.GONE);
                myView.findViewById(R.id.pb_empty).setVisibility(View.VISIBLE);
                new Handler().postDelayed(() -> {
                    myView.findViewById(R.id.iv_empty).setVisibility(View.VISIBLE);
                    myView.findViewById(R.id.pb_empty).setVisibility(View.GONE);
                    loadRe();
                }, 500);
            });

            frameLayout.addView(myView);
        }
    }

    private void addMenuProvider() {
        MenuHost menuHost = requireActivity();
        menuHost.addMenuProvider(new MenuProvider() {
            @Override
            public void onCreateMenu(@NonNull Menu menu, @NonNull MenuInflater menuInflater) {
                menu.clear();
                menuInflater.inflate(R.menu.menu_search, menu);

                // Configure the search menu item
                MenuItem item = menu.findItem(R.id.menu_search);
                item.setShowAsAction(MenuItem.SHOW_AS_ACTION_COLLAPSE_ACTION_VIEW | MenuItem.SHOW_AS_ACTION_IF_ROOM);
                searchView = (SearchView) item.getActionView();
                if (searchView != null) {
                    searchView.setOnQueryTextListener(queryTextListener);
                }
            }

            @Override
            public boolean onMenuItemSelected(@NonNull MenuItem menuItem) {
                // Handle menu item selection if necessary
                return false;
            }
        }, getViewLifecycleOwner());
    }

    SearchView.OnQueryTextListener queryTextListener = new SearchView.OnQueryTextListener() {
        @Override
        public boolean onQueryTextSubmit(String s) {
            return false;
        }

        @SuppressLint("NotifyDataSetChanged")
        @Override
        public boolean onQueryTextChange(String s) {
            if (adapter != null && (!searchView.isIconified())) {
                adapter.getFilter().filter(s);
                adapter.notifyDataSetChanged();
            }
            return true;
        }
    };

    @SuppressLint("NotifyDataSetChanged")
    @Subscribe(sticky = true, threadMode = ThreadMode.MAIN)
    public void onEquilizerChange(ItemCat itemCat) {
        if (adapter != null){
            adapter.notifyDataSetChanged();
        }
        GlobalBus.getBus().removeStickyEvent(itemCat);
    }

    @Override
    public void onStart() {
        super.onStart();
        GlobalBus.getBus().register(this);
    }

    @Override
    public void onStop() {
        GlobalBus.getBus().unregister(this);
        super.onStop();
    }
}